<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Enter Payment Details</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>

<!-- Main Content -->
<div class="container mt-5">
  <h2 class="text-center mb-4">Enter Payment Details</h2>

  <!-- Payment Form -->
  <form id="paymentForm" method="POST">
    <div class="row mb-3">
      <!-- Registration Number -->
      <div class="col-md-12">
        <label for="registrationNumber" class="form-label">Registration Number</label>
        <input type="text" class="form-control" name="registration_number" id="registrationNumber" placeholder="Enter registration number" required>
      </div>

      <!-- Tuition Fee -->
      <div class="col-md-12">
        <label for="tuitionFee" class="form-label">Tuition Fee (TZS)</label>
        <input type="number" class="form-control" name="tuition_fee" id="tuitionFee" placeholder="Enter tuition fee" required>
      </div>

      <!-- Other Fees -->
      <div class="col-md-12">
        <label for="otherFees" class="form-label">Other Fees (TZS)</label>
        <input type="number" class="form-control" name="other_fee" id="otherFees" placeholder="Enter other fees" required>
      </div>

      <!-- Total Amount Paid -->
      <div class="col-md-12">
        <label for="amountPaid" class="form-label">Total Amount Paid (TZS)</label>
        <input type="number" class="form-control" name="amount_paid" id="amountPaid" placeholder="Total amount paid" readonly>
      </div>

      <!-- Payment Method -->
      <div class="col-md-12">
        <label for="paymentMethod" class="form-label">Payment Method</label>
        <select class="form-select" name="payment_method" id="paymentMethod" required>
          <option value="" disabled selected>Select Payment Method</option>
          <option value="Mobile Money">Mobile Money</option>
          <option value="Bank Transfer">Bank Transfer</option>
          <option value="Cash">Cash</option>
        </select>
      </div>

      <!-- Payment Status -->
      <div class="col-md-12">
        <label for="paymentStatus" class="form-label">Payment Status</label>
        <select class="form-select" id="paymentStatus" name="payment_status" required>
          <option value="" disabled selected>Select Payment Status</option>
          <option value="Completed">Completed</option>
          <option value="Partial">Partial</option>
          <option value="Not Paid">Not Paid</option>
        </select>
      </div>
    </div>

    <div class="text-center">
      <button type="submit" id="submitBtn" class="btn btn-primary">Submit Payment</button>
    </div>
  </form>

  <div id="responseMessage" class="mt-4"></div>
</div>

<script>
  // Calculate total amount automatically when tuition or other fees are entered
  const tuitionFee = document.getElementById('tuitionFee');
  const otherFees = document.getElementById('otherFees');
  const amountPaid = document.getElementById('amountPaid');

  function calculateTotal() {
    const tuition = parseFloat(tuitionFee.value) || 0;
    const other = parseFloat(otherFees.value) || 0;
    amountPaid.value = tuition + other;
  }

  tuitionFee.addEventListener('input', calculateTotal);
  otherFees.addEventListener('input', calculateTotal);

  // AJAX Form Submission
  document.getElementById('paymentForm').addEventListener('submit', function (e) {
    e.preventDefault();  // Prevent form from submitting normally

    const formData = new FormData(this);

    // Send AJAX request
    const xhr = new XMLHttpRequest();
    xhr.open('POST', 'process_fees_payment.php', true);
    xhr.onload = function () {
      if (xhr.status === 200) {
        const response = JSON.parse(xhr.responseText);
        const messageDiv = document.getElementById('responseMessage');
        if (response.status === 'success') {
          messageDiv.innerHTML = `<div class="alert alert-success">${response.message}</div>`;
        } else {
          messageDiv.innerHTML = `<div class="alert alert-danger">${response.message}</div>`;
        }
      }
    };
    xhr.send(formData);
  });
</script>

<!-- Bootstrap JS and dependencies -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>
